close all
clear all

load plot_data.mat

%% FIGURE#7

figure(7)
subplot(1,2,1)
plot(freq,S12_meas,'r')
title 'Magnitude response'
xlabel 'Frequency'
ylabel '|H(f)|[dB]'
hold on
subplot(1,2,2)
plot(freq,S12_phase,'r')
title 'Phase response'
xlabel 'Frequency'
ylabel 'Phase in radians'
hold on

subplot(1,2,1)
plot(freq,S21_dez,'b')
legend('Measurements','Equivalent Circuit','Location','South')
grid
subplot(1,2,2)
plot(freq,S21_phase_dez,'b')
legend('Measurements','Equivalent Circuit','Location','South')
grid

%% FIGURE#8

figure(8)
subplot(1,2,1)
plot(freq,S12_meas,'r')
title 'Magnitude response'
xlabel 'Frequency'
ylabel '|H(f)|[dB]'
hold on
subplot(1,2,2)
plot(freq,S12_phase,'r')
title 'Phase response'
xlabel 'Frequency'
ylabel 'Phase in radians'
hold on

subplot(1,2,1)
plot(freq,S21_dez,'b')
subplot(1,2,2)
plot(freq,S21_phase_dez,'b')

subplot(1,2,1)
plot(F(Z),20*log10(abs(H_band)),'m')
legend('Measurements','Equivalent Circuit','FIR filter model','Location','South')
grid
subplot(1,2,2)
plot(F(Z),unwrap(angle(H_band)),'m')
legend('Measurements','Equivalent Circuit','FIR filter model','Location','South')
grid

%% FIGURE#9
H=fvtool(hd_10, 1,'Fs',1/dt, 'Analysis', 'freq', 'FrequencyRange', 'Specify freq. vector', 'FrequencyVector', [15e6:0.001e6:21e6]);
title 'Magnitude Response (dB) and Phase Response for 10 cm resonant coils distance'

%% FIGURE#10
H=fvtool(hd_20, 1,'Fs',1/dt, 'Analysis', 'freq', 'FrequencyRange', 'Specify freq. vector', 'FrequencyVector', [15e6:0.001e6:21e6]);
title 'Magnitude Response (dB) and Phase Response for 20 cm resonant tuned coils distance'

%% FIGURE#11
H=fvtool(hd_30, 1,'Fs',1/dt, 'Analysis', 'freq', 'FrequencyRange', 'Specify freq. vector', 'FrequencyVector', [15e6:0.001e6:21e6]);
title 'Magnitude Response (dB) and Phase Response for 30cm resonant tuned coils distance'

%% FIGURE#12
H=fvtool(hd_10_tuned, 1,'Fs',1/dt, 'Analysis', 'freq', 'FrequencyRange', 'Specify freq. vector', 'FrequencyVector', [15e6:0.001e6:21e6]);
title 'Magnitude Response (dB) and Phase Response for 10 cm resonant TUNED coils distance'
