//#define RK
//#define TRAPEZ
//#define RK4

// Mind that the integration follows the analog computing paradigm:
// The resulting sign is flipped. This adds a global minus.

// Also mind that the dydt_old are not consistently initialized
// for all problems. We have kind of "copy initial conditions" for older
// timelevels

#ifdef TRAPEZ
void __integrate(double *y, double dydt, double dt, double *dydt_old) {
  // This is actually identical to a RK2 scheme.
  *y -= (dydt + *dydt_old) / 2. * dt;
  *dydt_old = dydt;
}
#elif defined RK4
void __integrate(double *y, double dydt, double dt, double *dydt_old) {
  double k[4];
  k[0] = dydt;
  k[1] = dydt + 0.5*dt*k[0];
  k[2] = dydt + 0.5*dt*k[1];
  k[3] = dydt + 1.0*dt*k[2];
  *y -= dt/6.0*(k[0] + 2.0*k[1] + 2.0*k[2] + k[3]);
  dydt_old[3] = dydt_old[2];
  dydt_old[2] = dydt_old[1];
  dydt_old[1] = dydt_old[0];
  dydt_old[0] = dydt;
}
#else // Euler
void __integrate(double *y, double dydt, double dt, double *y_old) {
  *y -= dydt * dt;
}
#endif
