
/*
** Program name           : exp_dda.c
** Program source         : exp.dda
** Time of compilation    : Tue Jun  2 09:17:13 2020
** Variables to be plotted: y, fix_y, t
** Modulus:               : 1
*/

#include <stdio.h>
#include <math.h>

#include <time.h>
#include <stdlib.h>

#include "dda.h"

// call this function to start a nanosecond-resolution timer
struct timespec timer_start(){
    struct timespec start_time;
    clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &start_time);
    return start_time;
}

// call this function to end a timer, returning nanoseconds elapsed as a long
long timer_end(struct timespec start_time){
    struct timespec end_time;
    clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &end_time);
    long diffInNanos = (end_time.tv_sec - start_time.tv_sec) * (long)1e9 + (end_time.tv_nsec - start_time.tv_nsec);
    return diffInNanos;
}

int loop() {    
  /* Constant declarations */
  double dt = 0.0005;
  double minus_dy0 = -1;
  double y0 = -1;

  /* Initial value definitions */
  double __S0_41 = -minus_dy0;
  double fix_y = -y0;
  double minus_dy = -minus_dy0;
  double t = 0;
  double y = -y0;

  /* Scratch variables */
  double __dyold___S0_41[6] = {__S0_41, __S0_41, __S0_41, __S0_41, __S0_41, __S0_41, };
  double __dyold_fix_y[6] = {fix_y, fix_y, fix_y, fix_y, fix_y, fix_y, };
  double __dyold_minus_dy[6] = {minus_dy, minus_dy, minus_dy, minus_dy, minus_dy, minus_dy, };
  double __dyold_t[6] = {t, t, t, t, t, t, };
  double __dyold_y[6] = {y, y, y, y, y, y, };

  /* Variable definitions */
  double fix_minus_dy = 0.;

  /* Auxiliary variable definitions */
  unsigned int __i;

  /* Integration loop */
  for (__i = 0; __i < 10000; __i++) {
    fix_minus_dy = fabs(__S0_41);
    __integrate(&t, 1, dt, __dyold_t);;
    __integrate(&minus_dy, y, dt, __dyold_minus_dy);;
    __integrate(&y, minus_dy, dt, __dyold_y);;
    __integrate(&__S0_41, fix_y, dt, __dyold___S0_41);;
    __integrate(&fix_y, fix_minus_dy, dt, __dyold_fix_y);;

    if(t < -1) return __i; // negative sign, whatever
    ///* Write results to stdout */
    //if (!(__i % 1))
    //    printf("%.12g %.12g %.12g \n", y, fix_y, t);
  }
  
  return -1;
}


int main() {
    int times = 10000;
    int steps = 0; // to avoid optimizations
    
    struct timespec t0 = timer_start();
    for(int i=0; i<times; i++) {
        int res = loop();
        if(res < 1) { printf("Failure\n"); exit(-1); }
        steps += res;
    }
    long duration = timer_end(t0);

    
    printf("Number of total runs: %d\n", times);
    printf("Number of total steps: %d\n", steps);
    printf("Total duration: %d nanoseconds\n", duration);
    printf("\n");
    printf("Time per run to t=1: %d nanoseconds\n", duration/times);
    printf("Time per step: %d nanoseconds\n", duration/steps);

    return 0;
}
    
