/*
 * Basis-Code ist Ergebnis von
 * 
 *   ../harmonischer_oszillator/DDA/dda2c.pl notch_skaliert_aufgeraeumt.dda 3000 10 cnr               
 *
 * D.h. N=3000 Schritte werden berechnet.
 * Program name           : notch_skaliert_aufgeraeumt_dda.c
 * Program source         : notch_skaliert_aufgeraeumt.dda
 * Time of compilation    : Tue Jun  9 17:09:54 2020
 * Variables to be plotted: cnr
 * Modulus:               : 10
 */

#include <stdio.h>
#include <math.h>

#include <time.h>
#include <stdlib.h>

#include <math.h> // pow
#include <float.h> // DBL_MAX

#include "dda.h"

// call this function to start a nanosecond-resolution timer
struct timespec timer_start(){
    struct timespec start_time;
    clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &start_time);
    return start_time;
}

// call this function to end a timer, returning nanoseconds elapsed as a long
long long timer_end(struct timespec start_time){
    struct timespec end_time;
    clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &end_time);
    long long diffInNanos = (end_time.tv_sec - start_time.tv_sec) * (long)1e9 + (end_time.tv_nsec - start_time.tv_nsec);
    return diffInNanos;
}

#define N  3000  // Number of steps

double proof[N]; // Storage

double loop(double dummy_zero_input) {
  /* Constant declarations */
  double cd_ic = 1;
  double cn_ic = .85;
  double cr_ic = 1;
  double dt = .01;
  double km1 = .5;
  double km2 = .5;
  double km3 = .5;
  double kp1 = .5;
  double kp2 = .5;
  double kp3 = .5;
  double kubi = .5;

  /* Initial value definitions */
  double cd_minus = -cd_ic;
  double cn_minus = -cn_ic;
  double cnr_minus = 0;
  double cnrd_minus = 0;
  double cr_minus = -cr_ic;
  double crd_minus = 0;

  /* Scratch variables */
  double __dyold_cd_minus[6] = {cd_minus, cd_minus, cd_minus, cd_minus, cd_minus, cd_minus, };
  double __dyold_cn_minus[6] = {cn_minus, cn_minus, cn_minus, cn_minus, cn_minus, cn_minus, };
  double __dyold_cnr_minus[6] = {cnr_minus, cnr_minus, cnr_minus, cnr_minus, cnr_minus, cnr_minus, };
  double __dyold_cnrd_minus[6] = {cnrd_minus, cnrd_minus, cnrd_minus, cnrd_minus, cnrd_minus, cnrd_minus, };
  double __dyold_cr_minus[6] = {cr_minus, cr_minus, cr_minus, cr_minus, cr_minus, cr_minus, };
  double __dyold_crd_minus[6] = {crd_minus, crd_minus, crd_minus, crd_minus, crd_minus, crd_minus, };

  /* Variable definitions */
  double __S0_24 = 0.;
  double __S0_30 = 0.;
  double __S0_36 = 0.;
  double __S0_52 = 0.;
  double __S0_53 = 0.;
  double __S0_54 = 0.;
  double __S1_52 = 0.;
  double __S1_53 = 0.;
  double __S1_54 = 0.;
  double __S2_52 = 0.;
  double __S3_52 = 0.;
  double alpha = 0.;
  double alpha_minus = 0.;
  double beta = 0.;
  double beta_minus = 0.;
  double cd = 0.;
  double cn = 0.;
  double cnr = 0.;
  double cnrd = 0.;
  double cr = 0.;
  double crd = 0.;
  double delta = 0.;
  double delta_minus = 0.;
  double epsilon = 0.;
  double epsilon_minus = 0.;
  double eta_minus = 0.;
  double gamma = 0.;
  double gamma_minus = 0.;
  double zeta = 0.;
  double zeta_minus = 0.;

  /* Auxiliary variable definitions */
  unsigned int __i;

  /* Integration loop */
  for (__i = 0; __i < N; __i++) {
    __S0_24 = cn_minus * cr + dummy_zero_input+ dummy_zero_input;
    alpha_minus = kp1 * __S0_24+ dummy_zero_input;
    alpha = -alpha_minus+ dummy_zero_input;
    beta = km1 * cnr+ dummy_zero_input;
    beta_minus = -beta+ dummy_zero_input;
    __S0_30 = cnr * cd_minus+ dummy_zero_input;
    gamma_minus = kp2 * __S0_30+ dummy_zero_input;
    gamma = -gamma_minus+ dummy_zero_input;
    delta = km2 * cnrd+ dummy_zero_input;
    delta_minus = -delta + dummy_zero_input+ dummy_zero_input;
    __S0_36 = cd_minus * cr+ dummy_zero_input;
    epsilon_minus = kp3 * __S0_36+ dummy_zero_input;
    epsilon = -epsilon_minus+ dummy_zero_input;
    zeta = km3 * crd+ dummy_zero_input;
    zeta_minus = -zeta+ dummy_zero_input;
    eta_minus = kubi * cnr_minus+ dummy_zero_input;
    cn = -cn_minus+ dummy_zero_input;
    cr = -cr_minus+ dummy_zero_input;
    cd = -cd_minus + dummy_zero_input+ dummy_zero_input;
    cnr = -cnr_minus+ dummy_zero_input;
    crd = -crd_minus+ dummy_zero_input;
    cnrd = -cnrd_minus+ dummy_zero_input;
    __S0_52 = .01 * alpha_minus+ dummy_zero_input;
    __S1_52 = .01 * epsilon_minus+ dummy_zero_input;
    __S2_52 = .01 * beta+ dummy_zero_input;
    __S3_52 = .01 * zeta+ dummy_zero_input;
    __S0_53 = .01 * gamma_minus+ dummy_zero_input;
    __S1_53 = .01 * delta+ dummy_zero_input;
    __S0_54 = .01 * gamma_minus+ dummy_zero_input;
    __S1_54 = .01 * delta + dummy_zero_input+ dummy_zero_input;
    __integrate(&cn_minus, alpha_minus+beta+ dummy_zero_input, dt, __dyold_cn_minus);;
    __integrate(&cr_minus, __S0_52+__S1_52+__S2_52+__S3_52+ dummy_zero_input, dt, __dyold_cr_minus);;
    __integrate(&cd_minus, __S0_53+epsilon_minus+__S1_53+zeta+ dummy_zero_input, dt, __dyold_cd_minus);;
    __integrate(&cnr_minus, alpha+__S0_54+eta_minus+__S1_54+beta_minus+ dummy_zero_input, dt, __dyold_cnr_minus);;
    __integrate(&crd_minus, zeta_minus+epsilon+ dummy_zero_input, dt, __dyold_crd_minus);;
    __integrate(&cnrd_minus, delta_minus+gamma+ dummy_zero_input, dt, __dyold_cnrd_minus);;

    /* Write results to stdout */
    //if (!(__i % 10))
        proof[__i] = cnr;
        //printf("%.12g \n", cnr);
  }

  return cn_minus*cr_minus*cnr_minus*crd_minus;
}

void postprocess() {
    double min = DBL_MAX, max = -DBL_MAX;
    for(int i=0; i<N; i++) {
        if(proof[i] < min) min = proof[i];
        if(proof[i] > max) max = proof[i];
    }
    printf("min = %f, max = %f\n", min, max);
}


int main() {
    double dummy = 0;
    long long times = 1e5;
    long long steps = 0; // to avoid optimizations
    
    double dummy_zero_input = -1;
    
    char* zero = getenv("DUMMY_ZERO");
    if(zero)
        dummy_zero_input = atoi(zero);
    
    char *times_overwrite = getenv("EXP_REPETITIONS");
    if(times_overwrite)
        times = pow(10, atoi(times_overwrite));
    
    // this is just to avoid the compiler optimize EVERYTHING away!
    if(dummy_zero_input) {
        printf("Please provide dummy zero input as 0. %f given\n", dummy_zero_input);
        exit(-1);
    }
    
    struct timespec t0 = timer_start();
    for(int i=0; i<times; i++) {
        dummy += loop(dummy_zero_input);
        steps += N;
    }
    long long duration = timer_end(t0);

    printf("Dummy result to avoid compiler optimization: %f\n", dummy);
    postprocess(); // just for making sure at least something was computed
    printf("Number of total runs: %e\n", (double) times);
    printf("Number of steps per run: %d\n", N);
    printf("Number of total steps: %e\n", (double)steps);
    printf("Total duration: %e nanoseconds\n", (double)duration);
    printf("\n");
    printf("Time per run to t_final: %lld nanoseconds\n", duration/times);
    printf("Time per step: %lld nanoseconds\n", duration/steps);

    return 0;
}
    
